package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PolicyRoot;
import odata.msgraph.client.beta.entity.collection.request.ActivityBasedTimeoutPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ClaimsMappingPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConditionalAccessPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HomeRealmDiscoveryPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenIssuancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenLifetimePolicyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PolicyRootRequest extends EntityRequest<PolicyRoot> {

    public PolicyRootRequest(ContextPath contextPath) {
        super(PolicyRoot.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AuthenticationFlowsPolicyRequest authenticationFlowsPolicy() {
        return new AuthenticationFlowsPolicyRequest(contextPath.addSegment("authenticationFlowsPolicy"));
    }

    public DeviceRegistrationPolicyRequest deviceRegistrationPolicy() {
        return new DeviceRegistrationPolicyRequest(contextPath.addSegment("deviceRegistrationPolicy"));
    }

    public ActivityBasedTimeoutPolicyCollectionRequest activityBasedTimeoutPolicies() {
        return new ActivityBasedTimeoutPolicyCollectionRequest(
                        contextPath.addSegment("activityBasedTimeoutPolicies"));
    }

    public ActivityBasedTimeoutPolicyRequest activityBasedTimeoutPolicies(String id) {
        return new ActivityBasedTimeoutPolicyRequest(contextPath.addSegment("activityBasedTimeoutPolicies").addKeys(new NameValue(id.toString())));
    }

    public ClaimsMappingPolicyCollectionRequest claimsMappingPolicies() {
        return new ClaimsMappingPolicyCollectionRequest(
                        contextPath.addSegment("claimsMappingPolicies"));
    }

    public ClaimsMappingPolicyRequest claimsMappingPolicies(String id) {
        return new ClaimsMappingPolicyRequest(contextPath.addSegment("claimsMappingPolicies").addKeys(new NameValue(id.toString())));
    }

    public HomeRealmDiscoveryPolicyCollectionRequest homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(
                        contextPath.addSegment("homeRealmDiscoveryPolicies"));
    }

    public HomeRealmDiscoveryPolicyRequest homeRealmDiscoveryPolicies(String id) {
        return new HomeRealmDiscoveryPolicyRequest(contextPath.addSegment("homeRealmDiscoveryPolicies").addKeys(new NameValue(id.toString())));
    }

    public TokenIssuancePolicyCollectionRequest tokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(
                        contextPath.addSegment("tokenIssuancePolicies"));
    }

    public TokenIssuancePolicyRequest tokenIssuancePolicies(String id) {
        return new TokenIssuancePolicyRequest(contextPath.addSegment("tokenIssuancePolicies").addKeys(new NameValue(id.toString())));
    }

    public TokenLifetimePolicyCollectionRequest tokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(
                        contextPath.addSegment("tokenLifetimePolicies"));
    }

    public TokenLifetimePolicyRequest tokenLifetimePolicies(String id) {
        return new TokenLifetimePolicyRequest(contextPath.addSegment("tokenLifetimePolicies").addKeys(new NameValue(id.toString())));
    }

    public AdminConsentRequestPolicyRequest adminConsentRequestPolicy() {
        return new AdminConsentRequestPolicyRequest(contextPath.addSegment("adminConsentRequestPolicy"));
    }

    public DirectoryRoleAccessReviewPolicyRequest directoryRoleAccessReviewPolicy() {
        return new DirectoryRoleAccessReviewPolicyRequest(contextPath.addSegment("directoryRoleAccessReviewPolicy"));
    }

    public IdentitySecurityDefaultsEnforcementPolicyRequest identitySecurityDefaultsEnforcementPolicy() {
        return new IdentitySecurityDefaultsEnforcementPolicyRequest(contextPath.addSegment("identitySecurityDefaultsEnforcementPolicy"));
    }

    public ConditionalAccessPolicyCollectionRequest conditionalAccessPolicies() {
        return new ConditionalAccessPolicyCollectionRequest(
                        contextPath.addSegment("conditionalAccessPolicies"));
    }

    public ConditionalAccessPolicyRequest conditionalAccessPolicies(String id) {
        return new ConditionalAccessPolicyRequest(contextPath.addSegment("conditionalAccessPolicies").addKeys(new NameValue(id.toString())));
    }

}
