package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PlannerUser;
import odata.msgraph.client.beta.entity.collection.request.PlannerDeltaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerPlanCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PlannerUserRequest extends EntityRequest<PlannerUser> {

    public PlannerUserRequest(ContextPath contextPath) {
        super(PlannerUser.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"));
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id.toString())));
    }

    public PlannerPlanCollectionRequest plans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("plans"));
    }

    public PlannerPlanRequest plans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("plans").addKeys(new NameValue(id.toString())));
    }

    public PlannerPlanCollectionRequest favoritePlans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("favoritePlans"));
    }

    public PlannerPlanRequest favoritePlans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("favoritePlans").addKeys(new NameValue(id.toString())));
    }

    public PlannerPlanCollectionRequest recentPlans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("recentPlans"));
    }

    public PlannerPlanRequest recentPlans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("recentPlans").addKeys(new NameValue(id.toString())));
    }

    public PlannerDeltaCollectionRequest all() {
        return new PlannerDeltaCollectionRequest(
                        contextPath.addSegment("all"));
    }

    public PlannerDeltaRequest all(String id) {
        return new PlannerDeltaRequest(contextPath.addSegment("all").addKeys(new NameValue(id.toString())));
    }

}
