package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.PlannerTask;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PlannerTaskRequest extends EntityRequest<PlannerTask> {

    public PlannerTaskRequest(ContextPath contextPath) {
        super(PlannerTask.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PlannerTaskDetailsRequest details() {
        return new PlannerTaskDetailsRequest(contextPath.addSegment("details"));
    }

    public PlannerAssignedToTaskBoardTaskFormatRequest assignedToTaskBoardFormat() {
        return new PlannerAssignedToTaskBoardTaskFormatRequest(contextPath.addSegment("assignedToTaskBoardFormat"));
    }

    public PlannerProgressTaskBoardTaskFormatRequest progressTaskBoardFormat() {
        return new PlannerProgressTaskBoardTaskFormatRequest(contextPath.addSegment("progressTaskBoardFormat"));
    }

    public PlannerBucketTaskBoardTaskFormatRequest bucketTaskBoardFormat() {
        return new PlannerBucketTaskBoardTaskFormatRequest(contextPath.addSegment("bucketTaskBoardFormat"));
    }

}
