package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PlannerPlan;
import odata.msgraph.client.beta.entity.collection.request.PlannerBucketCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PlannerPlanRequest extends EntityRequest<PlannerPlan> {

    public PlannerPlanRequest(ContextPath contextPath) {
        super(PlannerPlan.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"));
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id.toString())));
    }

    public PlannerBucketCollectionRequest buckets() {
        return new PlannerBucketCollectionRequest(
                        contextPath.addSegment("buckets"));
    }

    public PlannerBucketRequest buckets(String id) {
        return new PlannerBucketRequest(contextPath.addSegment("buckets").addKeys(new NameValue(id.toString())));
    }

    public PlannerPlanDetailsRequest details() {
        return new PlannerPlanDetailsRequest(contextPath.addSegment("details"));
    }

}
