package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PlannerGroup;
import odata.msgraph.client.beta.entity.collection.request.PlannerPlanCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PlannerGroupRequest extends EntityRequest<PlannerGroup> {

    public PlannerGroupRequest(ContextPath contextPath) {
        super(PlannerGroup.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PlannerPlanCollectionRequest plans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("plans"));
    }

    public PlannerPlanRequest plans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("plans").addKeys(new NameValue(id.toString())));
    }

}
