package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PlannerBucket;
import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PlannerBucketRequest extends EntityRequest<PlannerBucket> {

    public PlannerBucketRequest(ContextPath contextPath) {
        super(PlannerBucket.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"));
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id.toString())));
    }

}
