package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PermissionGrantPolicy;
import odata.msgraph.client.beta.entity.collection.request.PermissionGrantConditionSetCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PermissionGrantPolicyRequest extends EntityRequest<PermissionGrantPolicy> {

    public PermissionGrantPolicyRequest(ContextPath contextPath) {
        super(PermissionGrantPolicy.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PermissionGrantConditionSetCollectionRequest includes() {
        return new PermissionGrantConditionSetCollectionRequest(
                        contextPath.addSegment("includes"));
    }

    public PermissionGrantConditionSetRequest includes(String id) {
        return new PermissionGrantConditionSetRequest(contextPath.addSegment("includes").addKeys(new NameValue(id.toString())));
    }

    public PermissionGrantConditionSetCollectionRequest excludes() {
        return new PermissionGrantConditionSetCollectionRequest(
                        contextPath.addSegment("excludes"));
    }

    public PermissionGrantConditionSetRequest excludes(String id) {
        return new PermissionGrantConditionSetRequest(contextPath.addSegment("excludes").addKeys(new NameValue(id.toString())));
    }

}
