package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.MuteParticipantOperation;
import odata.msgraph.client.beta.entity.Participant;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ParticipantRequest extends EntityRequest<Participant> {

    public ParticipantRequest(ContextPath contextPath) {
        super(Participant.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "mute")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MuteParticipantOperation> mute(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MuteParticipantOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.mute"), MuteParticipantOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
