package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OutlookTaskGroup;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskFolderCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class OutlookTaskGroupRequest extends EntityRequest<OutlookTaskGroup> {

    public OutlookTaskGroupRequest(ContextPath contextPath) {
        super(OutlookTaskGroup.class, contextPath, SchemaInfo.INSTANCE);
    }

    public OutlookTaskFolderCollectionRequest taskFolders() {
        return new OutlookTaskFolderCollectionRequest(
                        contextPath.addSegment("taskFolders"));
    }

    public OutlookTaskFolderRequest taskFolders(String id) {
        return new OutlookTaskFolderRequest(contextPath.addSegment("taskFolders").addKeys(new NameValue(id.toString())));
    }

}
