package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OrganizationSettings;
import odata.msgraph.client.beta.entity.collection.request.ProfileCardPropertyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class OrganizationSettingsRequest extends EntityRequest<OrganizationSettings> {

    public OrganizationSettingsRequest(ContextPath contextPath) {
        super(OrganizationSettings.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ProfileCardPropertyCollectionRequest profileCardProperties() {
        return new ProfileCardPropertyCollectionRequest(
                        contextPath.addSegment("profileCardProperties"));
    }

    public ProfileCardPropertyRequest profileCardProperties(String id) {
        return new ProfileCardPropertyRequest(contextPath.addSegment("profileCardProperties").addKeys(new NameValue(id.toString())));
    }

    public ItemInsightsRequest itemInsights() {
        return new ItemInsightsRequest(contextPath.addSegment("itemInsights"));
    }

}
