package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.Organization;
import odata.msgraph.client.beta.entity.collection.request.CertificateBasedAuthConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OrganizationalBrandingCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class OrganizationRequest extends EntityRequest<Organization> {

    public OrganizationRequest(ContextPath contextPath) {
        super(Organization.class, contextPath, SchemaInfo.INSTANCE);
    }

    public OrganizationalBrandingCollectionRequest brandings() {
        return new OrganizationalBrandingCollectionRequest(
                        contextPath.addSegment("brandings"));
    }

    public OrganizationalBrandingRequest brandings(String id) {
        return new OrganizationalBrandingRequest(contextPath.addSegment("brandings").addKeys(new NameValue(id.toString())));
    }

    public CertificateBasedAuthConfigurationCollectionRequest certificateBasedAuthConfiguration() {
        return new CertificateBasedAuthConfigurationCollectionRequest(
                        contextPath.addSegment("certificateBasedAuthConfiguration"));
    }

    public CertificateBasedAuthConfigurationRequest certificateBasedAuthConfiguration(String id) {
        return new CertificateBasedAuthConfigurationRequest(contextPath.addSegment("certificateBasedAuthConfiguration").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

    public OrganizationSettingsRequest settings() {
        return new OrganizationSettingsRequest(contextPath.addSegment("settings"));
    }

    @Action(name = "setMobileDeviceManagementAuthority")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Integer> setMobileDeviceManagementAuthority() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Integer>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setMobileDeviceManagementAuthority"), Integer.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
