package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.OnenoteOperation;
import odata.msgraph.client.beta.entity.OnenoteSection;
import odata.msgraph.client.beta.entity.collection.request.OnenotePageCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class OnenoteSectionRequest extends EntityRequest<OnenoteSection> {

    public OnenoteSectionRequest(ContextPath contextPath) {
        super(OnenoteSection.class, contextPath, SchemaInfo.INSTANCE);
    }

    public NotebookRequest parentNotebook() {
        return new NotebookRequest(contextPath.addSegment("parentNotebook"));
    }

    public SectionGroupRequest parentSectionGroup() {
        return new SectionGroupRequest(contextPath.addSegment("parentSectionGroup"));
    }

    public OnenotePageCollectionRequest pages() {
        return new OnenotePageCollectionRequest(
                        contextPath.addSegment("pages"));
    }

    public OnenotePageRequest pages(String id) {
        return new OnenotePageRequest(contextPath.addSegment("pages").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "copyToNotebook")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation> copyToNotebook(String id, String groupId, String renameAs, String siteCollectionId, String siteId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("renameAs", "Edm.String", Checks.checkIsAscii(renameAs))
            .put("siteCollectionId", "Edm.String", Checks.checkIsAscii(siteCollectionId))
            .put("siteId", "Edm.String", Checks.checkIsAscii(siteId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyToNotebook"), OnenoteOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "copyToSectionGroup")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation> copyToSectionGroup(String id, String groupId, String renameAs, String siteCollectionId, String siteId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("renameAs", "Edm.String", Checks.checkIsAscii(renameAs))
            .put("siteCollectionId", "Edm.String", Checks.checkIsAscii(siteCollectionId))
            .put("siteId", "Edm.String", Checks.checkIsAscii(siteId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyToSectionGroup"), OnenoteOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
