package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.OnenotePagePreview;
import odata.msgraph.client.beta.complex.OnenotePatchContentCommand;
import odata.msgraph.client.beta.entity.OnenoteOperation;
import odata.msgraph.client.beta.entity.OnenotePage;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class OnenotePageRequest extends EntityRequest<OnenotePage> {

    public OnenotePageRequest(ContextPath contextPath) {
        super(OnenotePage.class, contextPath, SchemaInfo.INSTANCE);
    }

    public OnenoteSectionRequest parentSection() {
        return new OnenoteSectionRequest(contextPath.addSegment("parentSection"));
    }

    public NotebookRequest parentNotebook() {
        return new NotebookRequest(contextPath.addSegment("parentNotebook"));
    }

    @Action(name = "onenotePatchContent")
    @JsonIgnore
    public ActionRequestNoReturn onenotePatchContent(List<OnenotePatchContentCommand> commands) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("commands", "Collection(microsoft.graph.onenotePatchContentCommand)", commands)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.onenotePatchContent"), _parameters);
    }

    @Action(name = "copyToSection")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation> copyToSection(String id, String groupId, String siteCollectionId, String siteId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("siteCollectionId", "Edm.String", Checks.checkIsAscii(siteCollectionId))
            .put("siteId", "Edm.String", Checks.checkIsAscii(siteId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyToSection"), OnenoteOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "preview")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<OnenotePagePreview> preview() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<OnenotePagePreview>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.preview"), OnenotePagePreview.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
