package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OnPremisesAgentGroup;
import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PublishedResourceCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class OnPremisesAgentGroupRequest extends EntityRequest<OnPremisesAgentGroup> {

    public OnPremisesAgentGroupRequest(ContextPath contextPath) {
        super(OnPremisesAgentGroup.class, contextPath, SchemaInfo.INSTANCE);
    }

    public OnPremisesAgentCollectionRequest agents() {
        return new OnPremisesAgentCollectionRequest(
                        contextPath.addSegment("agents"));
    }

    public OnPremisesAgentRequest agents(String id) {
        return new OnPremisesAgentRequest(contextPath.addSegment("agents").addKeys(new NameValue(id.toString())));
    }

    public PublishedResourceCollectionRequest publishedResources() {
        return new PublishedResourceCollectionRequest(
                        contextPath.addSegment("publishedResources"));
    }

    public PublishedResourceRequest publishedResources(String id) {
        return new PublishedResourceRequest(contextPath.addSegment("publishedResources").addKeys(new NameValue(id.toString())));
    }

}
