package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OfficeGraphInsights;
import odata.msgraph.client.beta.entity.collection.request.SharedInsightCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TrendingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UsedInsightCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class OfficeGraphInsightsRequest extends EntityRequest<OfficeGraphInsights> {

    public OfficeGraphInsightsRequest(ContextPath contextPath) {
        super(OfficeGraphInsights.class, contextPath, SchemaInfo.INSTANCE);
    }

    public TrendingCollectionRequest trending() {
        return new TrendingCollectionRequest(
                        contextPath.addSegment("trending"));
    }

    public TrendingRequest trending(String id) {
        return new TrendingRequest(contextPath.addSegment("trending").addKeys(new NameValue(id.toString())));
    }

    public SharedInsightCollectionRequest shared() {
        return new SharedInsightCollectionRequest(
                        contextPath.addSegment("shared"));
    }

    public SharedInsightRequest shared(String id) {
        return new SharedInsightRequest(contextPath.addSegment("shared").addKeys(new NameValue(id.toString())));
    }

    public UsedInsightCollectionRequest used() {
        return new UsedInsightCollectionRequest(
                        contextPath.addSegment("used"));
    }

    public UsedInsightRequest used(String id) {
        return new UsedInsightRequest(contextPath.addSegment("used").addKeys(new NameValue(id.toString())));
    }

}
