package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.OfficeConfiguration;
import odata.msgraph.client.beta.entity.collection.request.OfficeClientConfigurationCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class OfficeConfigurationRequest extends EntityRequest<OfficeConfiguration> {

    public OfficeConfigurationRequest(ContextPath contextPath) {
        super(OfficeConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public OfficeClientConfigurationCollectionRequest clientConfigurations() {
        return new OfficeClientConfigurationCollectionRequest(
                        contextPath.addSegment("clientConfigurations"));
    }

    public OfficeClientConfigurationRequest clientConfigurations(String id) {
        return new OfficeClientConfigurationRequest(contextPath.addSegment("clientConfigurations").addKeys(new NameValue(id.toString())));
    }

}
