package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.NotificationMessageTemplate;
import odata.msgraph.client.beta.entity.collection.request.LocalizedNotificationMessageCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class NotificationMessageTemplateRequest extends EntityRequest<NotificationMessageTemplate> {

    public NotificationMessageTemplateRequest(ContextPath contextPath) {
        super(NotificationMessageTemplate.class, contextPath, SchemaInfo.INSTANCE);
    }

    public LocalizedNotificationMessageCollectionRequest localizedNotificationMessages() {
        return new LocalizedNotificationMessageCollectionRequest(
                        contextPath.addSegment("localizedNotificationMessages"));
    }

    public LocalizedNotificationMessageRequest localizedNotificationMessages(String id) {
        return new LocalizedNotificationMessageRequest(contextPath.addSegment("localizedNotificationMessages").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "sendTestMessage")
    @JsonIgnore
    public ActionRequestNoReturn sendTestMessage() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendTestMessage"), _parameters);
    }

}
