package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.Notebook;
import odata.msgraph.client.beta.entity.OnenoteOperation;
import odata.msgraph.client.beta.entity.collection.request.OnenoteSectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SectionGroupCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class NotebookRequest extends EntityRequest<Notebook> {

    public NotebookRequest(ContextPath contextPath) {
        super(Notebook.class, contextPath, SchemaInfo.INSTANCE);
    }

    public OnenoteSectionCollectionRequest sections() {
        return new OnenoteSectionCollectionRequest(
                        contextPath.addSegment("sections"));
    }

    public OnenoteSectionRequest sections(String id) {
        return new OnenoteSectionRequest(contextPath.addSegment("sections").addKeys(new NameValue(id.toString())));
    }

    public SectionGroupCollectionRequest sectionGroups() {
        return new SectionGroupCollectionRequest(
                        contextPath.addSegment("sectionGroups"));
    }

    public SectionGroupRequest sectionGroups(String id) {
        return new SectionGroupRequest(contextPath.addSegment("sectionGroups").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "copyNotebook")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation> copyNotebook(String groupId, String renameAs, String notebookFolder, String siteCollectionId, String siteId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("renameAs", "Edm.String", Checks.checkIsAscii(renameAs))
            .put("notebookFolder", "Edm.String", Checks.checkIsAscii(notebookFolder))
            .put("siteCollectionId", "Edm.String", Checks.checkIsAscii(siteCollectionId))
            .put("siteId", "Edm.String", Checks.checkIsAscii(siteId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyNotebook"), OnenoteOperation.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
