package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.MobileLobApp;
import odata.msgraph.client.beta.entity.collection.request.MobileAppContentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class MobileLobAppRequest extends EntityRequest<MobileLobApp> {

    public MobileLobAppRequest(ContextPath contextPath) {
        super(MobileLobApp.class, contextPath, SchemaInfo.INSTANCE);
    }

    public MobileAppContentCollectionRequest contentVersions() {
        return new MobileAppContentCollectionRequest(
                        contextPath.addSegment("contentVersions"));
    }

    public MobileAppContentRequest contentVersions(String id) {
        return new MobileAppContentRequest(contextPath.addSegment("contentVersions").addKeys(new NameValue(id.toString())));
    }

}
