package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.MobileAppTroubleshootingEvent;
import odata.msgraph.client.beta.entity.collection.request.AppLogCollectionRequestCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class MobileAppTroubleshootingEventRequest extends EntityRequest<MobileAppTroubleshootingEvent> {

    public MobileAppTroubleshootingEventRequest(ContextPath contextPath) {
        super(MobileAppTroubleshootingEvent.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AppLogCollectionRequestCollectionRequest appLogCollectionRequests() {
        return new AppLogCollectionRequestCollectionRequest(
                        contextPath.addSegment("appLogCollectionRequests"));
    }

    public AppLogCollectionRequestRequest appLogCollectionRequests(String id) {
        return new AppLogCollectionRequestRequest(contextPath.addSegment("appLogCollectionRequests").addKeys(new NameValue(id.toString())));
    }

}
