package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.MobileAppContent;
import odata.msgraph.client.beta.entity.collection.request.MobileAppContentFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileContainedAppCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class MobileAppContentRequest extends EntityRequest<MobileAppContent> {

    public MobileAppContentRequest(ContextPath contextPath) {
        super(MobileAppContent.class, contextPath, SchemaInfo.INSTANCE);
    }

    public MobileAppContentFileCollectionRequest files() {
        return new MobileAppContentFileCollectionRequest(
                        contextPath.addSegment("files"));
    }

    public MobileAppContentFileRequest files(String id) {
        return new MobileAppContentFileRequest(contextPath.addSegment("files").addKeys(new NameValue(id.toString())));
    }

    public MobileContainedAppCollectionRequest containedApps() {
        return new MobileContainedAppCollectionRequest(
                        contextPath.addSegment("containedApps"));
    }

    public MobileContainedAppRequest containedApps(String id) {
        return new MobileContainedAppRequest(contextPath.addSegment("containedApps").addKeys(new NameValue(id.toString())));
    }

}
