package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.FileEncryptionInfo;
import odata.msgraph.client.beta.entity.MobileAppContentFile;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class MobileAppContentFileRequest extends EntityRequest<MobileAppContentFile> {

    public MobileAppContentFileRequest(ContextPath contextPath) {
        super(MobileAppContentFile.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "commit")
    @JsonIgnore
    public ActionRequestNoReturn commit(FileEncryptionInfo fileEncryptionInfo) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("fileEncryptionInfo", "microsoft.graph.fileEncryptionInfo", fileEncryptionInfo)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.commit"), _parameters);
    }

    @Action(name = "renewUpload")
    @JsonIgnore
    public ActionRequestNoReturn renewUpload() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.renewUpload"), _parameters);
    }

}
