package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.MicrosoftStoreForBusinessApp;
import odata.msgraph.client.beta.entity.collection.request.MobileContainedAppCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class MicrosoftStoreForBusinessAppRequest extends EntityRequest<MicrosoftStoreForBusinessApp> {

    public MicrosoftStoreForBusinessAppRequest(ContextPath contextPath) {
        super(MicrosoftStoreForBusinessApp.class, contextPath, SchemaInfo.INSTANCE);
    }

    public MobileContainedAppCollectionRequest containedApps() {
        return new MobileContainedAppCollectionRequest(
                        contextPath.addSegment("containedApps"));
    }

    public MobileContainedAppRequest containedApps(String id) {
        return new MobileContainedAppRequest(contextPath.addSegment("containedApps").addKeys(new NameValue(id.toString())));
    }

}
