package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.Recipient;
import odata.msgraph.client.beta.entity.Message;
import odata.msgraph.client.beta.entity.collection.request.AttachmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MentionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class MessageRequest extends EntityRequest<Message> {

    public MessageRequest(ContextPath contextPath) {
        super(Message.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"));
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"));
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public AttachmentCollectionRequest attachments() {
        return new AttachmentCollectionRequest(
                        contextPath.addSegment("attachments"));
    }

    public AttachmentRequest attachments(String id) {
        return new AttachmentRequest(contextPath.addSegment("attachments").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

    public MentionCollectionRequest mentions() {
        return new MentionCollectionRequest(
                        contextPath.addSegment("mentions"));
    }

    public MentionRequest mentions(String id) {
        return new MentionRequest(contextPath.addSegment("mentions").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "createReply")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Message> createReply(Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Message>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createReply"), Message.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "createReplyAll")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Message> createReplyAll(Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Message>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createReplyAll"), Message.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "createForward")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Message> createForward(List<Recipient> toRecipients, Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ToRecipients", "Collection(microsoft.graph.recipient)", toRecipients)
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Message>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createForward"), Message.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "send")
    @JsonIgnore
    public ActionRequestNoReturn send() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.send"), _parameters);
    }

    @Action(name = "copy")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Message> copy(String destinationId) {
        Preconditions.checkNotNull(destinationId, "destinationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DestinationId", "Edm.String", Checks.checkIsAscii(destinationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Message>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copy"), Message.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "move")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Message> move(String destinationId) {
        Preconditions.checkNotNull(destinationId, "destinationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DestinationId", "Edm.String", Checks.checkIsAscii(destinationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Message>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.move"), Message.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "reply")
    @JsonIgnore
    public ActionRequestNoReturn reply(Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reply"), _parameters);
    }

    @Action(name = "replyAll")
    @JsonIgnore
    public ActionRequestNoReturn replyAll(Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.replyAll"), _parameters);
    }

    @Action(name = "forward")
    @JsonIgnore
    public ActionRequestNoReturn forward(List<Recipient> toRecipients, Message message, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ToRecipients", "Collection(microsoft.graph.recipient)", toRecipients)
            .put("Message", "microsoft.graph.message", message)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.forward"), _parameters);
    }

    @Action(name = "unsubscribe")
    @JsonIgnore
    public ActionRequestNoReturn unsubscribe() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unsubscribe"), _parameters);
    }

}
