package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.ManagementConditionExpressionString;
import odata.msgraph.client.beta.entity.ManagementConditionStatement;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ManagementConditionStatementRequest extends EntityRequest<ManagementConditionStatement> {

    public ManagementConditionStatementRequest(ContextPath contextPath) {
        super(ManagementConditionStatement.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ManagementConditionCollectionRequest managementConditions() {
        return new ManagementConditionCollectionRequest(
                        contextPath.addSegment("managementConditions"));
    }

    public ManagementConditionRequest managementConditions(String id) {
        return new ManagementConditionRequest(contextPath.addSegment("managementConditions").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "getManagementConditionStatementExpressionString")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ManagementConditionExpressionString> getManagementConditionStatementExpressionString() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ManagementConditionExpressionString>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagementConditionStatementExpressionString"), ManagementConditionExpressionString.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
