package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ManagementCondition;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionStatementCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ManagementConditionRequest extends EntityRequest<ManagementCondition> {

    public ManagementConditionRequest(ContextPath contextPath) {
        super(ManagementCondition.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ManagementConditionStatementCollectionRequest managementConditionStatements() {
        return new ManagementConditionStatementCollectionRequest(
                        contextPath.addSegment("managementConditionStatements"));
    }

    public ManagementConditionStatementRequest managementConditionStatements(String id) {
        return new ManagementConditionStatementRequest(contextPath.addSegment("managementConditionStatements").addKeys(new NameValue(id.toString())));
    }

}
