package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.ManagedEBook;
import odata.msgraph.client.beta.entity.ManagedEBookAssignment;
import odata.msgraph.client.beta.entity.collection.request.DeviceInstallStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedEBookAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedEBookCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserInstallStateSummaryCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ManagedEBookRequest extends EntityRequest<ManagedEBook> {

    public ManagedEBookRequest(ContextPath contextPath) {
        super(ManagedEBook.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ManagedEBookCategoryCollectionRequest categories() {
        return new ManagedEBookCategoryCollectionRequest(
                        contextPath.addSegment("categories"));
    }

    public ManagedEBookCategoryRequest categories(String id) {
        return new ManagedEBookCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id.toString())));
    }

    public ManagedEBookAssignmentCollectionRequest assignments() {
        return new ManagedEBookAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public ManagedEBookAssignmentRequest assignments(String id) {
        return new ManagedEBookAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public EBookInstallSummaryRequest installSummary() {
        return new EBookInstallSummaryRequest(contextPath.addSegment("installSummary"));
    }

    public DeviceInstallStateCollectionRequest deviceStates() {
        return new DeviceInstallStateCollectionRequest(
                        contextPath.addSegment("deviceStates"));
    }

    public DeviceInstallStateRequest deviceStates(String id) {
        return new DeviceInstallStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id.toString())));
    }

    public UserInstallStateSummaryCollectionRequest userStateSummary() {
        return new UserInstallStateSummaryCollectionRequest(
                        contextPath.addSegment("userStateSummary"));
    }

    public UserInstallStateSummaryRequest userStateSummary(String id) {
        return new UserInstallStateSummaryRequest(contextPath.addSegment("userStateSummary").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<ManagedEBookAssignment> managedEBookAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("managedEBookAssignments", "Collection(microsoft.graph.managedEBookAssignment)", managedEBookAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
