package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.ConfigurationManagerAction;
import odata.msgraph.client.beta.complex.DeviceCompliancePolicySettingState;
import odata.msgraph.client.beta.complex.DeviceLogCollectionRequest;
import odata.msgraph.client.beta.complex.UpdateWindowsDeviceAccountActionParameter;
import odata.msgraph.client.beta.entity.DeviceLogCollectionResponse;
import odata.msgraph.client.beta.entity.ManagedDevice;
import odata.msgraph.client.beta.entity.collection.request.DetectedAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicyStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceLogCollectionResponseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCollectionRequest;
import odata.msgraph.client.beta.enums.AdministratorConfiguredDeviceComplianceState;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ManagedDeviceRequest extends EntityRequest<ManagedDevice> {

    public ManagedDeviceRequest(ContextPath contextPath) {
        super(ManagedDevice.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SecurityBaselineStateCollectionRequest securityBaselineStates() {
        return new SecurityBaselineStateCollectionRequest(
                        contextPath.addSegment("securityBaselineStates"));
    }

    public SecurityBaselineStateRequest securityBaselineStates(String id) {
        return new SecurityBaselineStateRequest(contextPath.addSegment("securityBaselineStates").addKeys(new NameValue(id.toString())));
    }

    public DeviceConfigurationStateCollectionRequest deviceConfigurationStates() {
        return new DeviceConfigurationStateCollectionRequest(
                        contextPath.addSegment("deviceConfigurationStates"));
    }

    public DeviceConfigurationStateRequest deviceConfigurationStates(String id) {
        return new DeviceConfigurationStateRequest(contextPath.addSegment("deviceConfigurationStates").addKeys(new NameValue(id.toString())));
    }

    public DeviceCompliancePolicyStateCollectionRequest deviceCompliancePolicyStates() {
        return new DeviceCompliancePolicyStateCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicyStates"));
    }

    public DeviceCompliancePolicyStateRequest deviceCompliancePolicyStates(String id) {
        return new DeviceCompliancePolicyStateRequest(contextPath.addSegment("deviceCompliancePolicyStates").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceMobileAppConfigurationStateCollectionRequest managedDeviceMobileAppConfigurationStates() {
        return new ManagedDeviceMobileAppConfigurationStateCollectionRequest(
                        contextPath.addSegment("managedDeviceMobileAppConfigurationStates"));
    }

    public ManagedDeviceMobileAppConfigurationStateRequest managedDeviceMobileAppConfigurationStates(String id) {
        return new ManagedDeviceMobileAppConfigurationStateRequest(contextPath.addSegment("managedDeviceMobileAppConfigurationStates").addKeys(new NameValue(id.toString())));
    }

    public DetectedAppCollectionRequest detectedApps() {
        return new DetectedAppCollectionRequest(
                        contextPath.addSegment("detectedApps"));
    }

    public DetectedAppRequest detectedApps(String id) {
        return new DetectedAppRequest(contextPath.addSegment("detectedApps").addKeys(new NameValue(id.toString())));
    }

    public DeviceCategoryRequest deviceCategory() {
        return new DeviceCategoryRequest(contextPath.addSegment("deviceCategory"));
    }

    public WindowsProtectionStateRequest windowsProtectionState() {
        return new WindowsProtectionStateRequest(contextPath.addSegment("windowsProtectionState"));
    }

    public UserCollectionRequest users() {
        return new UserCollectionRequest(
                        contextPath.addSegment("users"));
    }

    public UserRequest users(String id) {
        return new UserRequest(contextPath.addSegment("users").addKeys(new NameValue(id.toString())));
    }

    public DeviceLogCollectionResponseCollectionRequest logCollectionRequests() {
        return new DeviceLogCollectionResponseCollectionRequest(
                        contextPath.addSegment("logCollectionRequests"));
    }

    public DeviceLogCollectionResponseRequest logCollectionRequests(String id) {
        return new DeviceLogCollectionResponseRequest(contextPath.addSegment("logCollectionRequests").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "overrideComplianceState")
    @JsonIgnore
    public ActionRequestNoReturn overrideComplianceState(AdministratorConfiguredDeviceComplianceState complianceState, String remediationUrl) {
        Preconditions.checkNotNull(complianceState, "complianceState cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("complianceState", "microsoft.graph.administratorConfiguredDeviceComplianceState", complianceState)
            .put("remediationUrl", "Edm.String", Checks.checkIsAscii(remediationUrl))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.overrideComplianceState"), _parameters);
    }

    @Action(name = "enableLostMode")
    @JsonIgnore
    public ActionRequestNoReturn enableLostMode(String message, String phoneNumber, String footer) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .put("phoneNumber", "Edm.String", Checks.checkIsAscii(phoneNumber))
            .put("footer", "Edm.String", Checks.checkIsAscii(footer))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableLostMode"), _parameters);
    }

    @Action(name = "playLostModeSound")
    @JsonIgnore
    public ActionRequestNoReturn playLostModeSound() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.playLostModeSound"), _parameters);
    }

    @Action(name = "setDeviceName")
    @JsonIgnore
    public ActionRequestNoReturn setDeviceName(String deviceName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceName", "Edm.String", Checks.checkIsAscii(deviceName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setDeviceName"), _parameters);
    }

    @Action(name = "rotateFileVaultKey")
    @JsonIgnore
    public ActionRequestNoReturn rotateFileVaultKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rotateFileVaultKey"), _parameters);
    }

    @Action(name = "createDeviceLogCollectionRequest")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeviceLogCollectionResponse> createDeviceLogCollectionRequest(DeviceLogCollectionRequest templateType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("templateType", "microsoft.graph.deviceLogCollectionRequest", templateType)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeviceLogCollectionResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createDeviceLogCollectionRequest"), DeviceLogCollectionResponse.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "retire")
    @JsonIgnore
    public ActionRequestNoReturn retire() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.retire"), _parameters);
    }

    @Action(name = "wipe")
    @JsonIgnore
    public ActionRequestNoReturn wipe(Boolean keepEnrollmentData, Boolean keepUserData, String macOsUnlockCode, Boolean useProtectedWipe) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keepEnrollmentData", "Edm.Boolean", keepEnrollmentData)
            .put("keepUserData", "Edm.Boolean", keepUserData)
            .put("macOsUnlockCode", "Edm.String", Checks.checkIsAscii(macOsUnlockCode))
            .put("useProtectedWipe", "Edm.Boolean", useProtectedWipe)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipe"), _parameters);
    }

    @Action(name = "resetPasscode")
    @JsonIgnore
    public ActionRequestNoReturn resetPasscode() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetPasscode"), _parameters);
    }

    @Action(name = "remoteLock")
    @JsonIgnore
    public ActionRequestNoReturn remoteLock() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.remoteLock"), _parameters);
    }

    @Action(name = "requestRemoteAssistance")
    @JsonIgnore
    public ActionRequestNoReturn requestRemoteAssistance() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.requestRemoteAssistance"), _parameters);
    }

    @Action(name = "disableLostMode")
    @JsonIgnore
    public ActionRequestNoReturn disableLostMode() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disableLostMode"), _parameters);
    }

    @Action(name = "locateDevice")
    @JsonIgnore
    public ActionRequestNoReturn locateDevice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.locateDevice"), _parameters);
    }

    @Action(name = "bypassActivationLock")
    @JsonIgnore
    public ActionRequestNoReturn bypassActivationLock() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bypassActivationLock"), _parameters);
    }

    @Action(name = "rebootNow")
    @JsonIgnore
    public ActionRequestNoReturn rebootNow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rebootNow"), _parameters);
    }

    @Action(name = "shutDown")
    @JsonIgnore
    public ActionRequestNoReturn shutDown() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.shutDown"), _parameters);
    }

    @Action(name = "recoverPasscode")
    @JsonIgnore
    public ActionRequestNoReturn recoverPasscode() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recoverPasscode"), _parameters);
    }

    @Action(name = "cleanWindowsDevice")
    @JsonIgnore
    public ActionRequestNoReturn cleanWindowsDevice(Boolean keepUserData) {
        Preconditions.checkNotNull(keepUserData, "keepUserData cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keepUserData", "Edm.Boolean", keepUserData)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cleanWindowsDevice"), _parameters);
    }

    @Action(name = "logoutSharedAppleDeviceActiveUser")
    @JsonIgnore
    public ActionRequestNoReturn logoutSharedAppleDeviceActiveUser() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.logoutSharedAppleDeviceActiveUser"), _parameters);
    }

    @Action(name = "deleteUserFromSharedAppleDevice")
    @JsonIgnore
    public ActionRequestNoReturn deleteUserFromSharedAppleDevice(String userPrincipalName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deleteUserFromSharedAppleDevice"), _parameters);
    }

    @Action(name = "syncDevice")
    @JsonIgnore
    public ActionRequestNoReturn syncDevice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncDevice"), _parameters);
    }

    @Action(name = "windowsDefenderScan")
    @JsonIgnore
    public ActionRequestNoReturn windowsDefenderScan(Boolean quickScan) {
        Preconditions.checkNotNull(quickScan, "quickScan cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("quickScan", "Edm.Boolean", quickScan)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsDefenderScan"), _parameters);
    }

    @Action(name = "windowsDefenderUpdateSignatures")
    @JsonIgnore
    public ActionRequestNoReturn windowsDefenderUpdateSignatures() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsDefenderUpdateSignatures"), _parameters);
    }

    @Action(name = "updateWindowsDeviceAccount")
    @JsonIgnore
    public ActionRequestNoReturn updateWindowsDeviceAccount(UpdateWindowsDeviceAccountActionParameter updateWindowsDeviceAccountActionParameter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("updateWindowsDeviceAccountActionParameter", "microsoft.graph.updateWindowsDeviceAccountActionParameter", updateWindowsDeviceAccountActionParameter)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateWindowsDeviceAccount"), _parameters);
    }

    @Action(name = "revokeAppleVppLicenses")
    @JsonIgnore
    public ActionRequestNoReturn revokeAppleVppLicenses() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeAppleVppLicenses"), _parameters);
    }

    @Action(name = "rotateBitLockerKeys")
    @JsonIgnore
    public ActionRequestNoReturn rotateBitLockerKeys() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rotateBitLockerKeys"), _parameters);
    }

    @Action(name = "sendCustomNotificationToCompanyPortal")
    @JsonIgnore
    public ActionRequestNoReturn sendCustomNotificationToCompanyPortal(String notificationTitle, String notificationBody) {
        Preconditions.checkNotNull(notificationTitle, "notificationTitle cannot be null");
        Preconditions.checkNotNull(notificationBody, "notificationBody cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notificationTitle", "Edm.String", Checks.checkIsAscii(notificationTitle))
            .put("notificationBody", "Edm.String", Checks.checkIsAscii(notificationBody))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendCustomNotificationToCompanyPortal"), _parameters);
    }

    @Action(name = "triggerConfigurationManagerAction")
    @JsonIgnore
    public ActionRequestNoReturn triggerConfigurationManagerAction(ConfigurationManagerAction configurationManagerAction) {
        Preconditions.checkNotNull(configurationManagerAction, "configurationManagerAction cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("configurationManagerAction", "microsoft.graph.configurationManagerAction", configurationManagerAction)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.triggerConfigurationManagerAction"), _parameters);
    }

    @Function(name = "getNonCompliantSettings")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceCompliancePolicySettingState> getNonCompliantSettings() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getNonCompliantSettings"), DeviceCompliancePolicySettingState.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getFileVaultKey")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getFileVaultKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getFileVaultKey"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
