package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.ManagedDeviceMobileAppConfiguration;
import odata.msgraph.client.beta.entity.ManagedDeviceMobileAppConfigurationAssignment;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ManagedDeviceMobileAppConfigurationRequest extends EntityRequest<ManagedDeviceMobileAppConfiguration> {

    public ManagedDeviceMobileAppConfigurationRequest(ContextPath contextPath) {
        super(ManagedDeviceMobileAppConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest assignments() {
        return new ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public ManagedDeviceMobileAppConfigurationAssignmentRequest assignments(String id) {
        return new ManagedDeviceMobileAppConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest deviceStatuses() {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"));
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusRequest deviceStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest userStatuses() {
        return new ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"));
    }

    public ManagedDeviceMobileAppConfigurationUserStatusRequest userStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceMobileAppConfigurationDeviceSummaryRequest deviceStatusSummary() {
        return new ManagedDeviceMobileAppConfigurationDeviceSummaryRequest(contextPath.addSegment("deviceStatusSummary"));
    }

    public ManagedDeviceMobileAppConfigurationUserSummaryRequest userStatusSummary() {
        return new ManagedDeviceMobileAppConfigurationUserSummaryRequest(contextPath.addSegment("userStatusSummary"));
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<ManagedDeviceMobileAppConfigurationAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.managedDeviceMobileAppConfigurationAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
