package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.MacOsVppApp;
import odata.msgraph.client.beta.entity.collection.request.MacOsVppAppAssignedLicenseCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class MacOsVppAppRequest extends EntityRequest<MacOsVppApp> {

    public MacOsVppAppRequest(ContextPath contextPath) {
        super(MacOsVppApp.class, contextPath, SchemaInfo.INSTANCE);
    }

    public MacOsVppAppAssignedLicenseCollectionRequest assignedLicenses() {
        return new MacOsVppAppAssignedLicenseCollectionRequest(
                        contextPath.addSegment("assignedLicenses"));
    }

    public MacOsVppAppAssignedLicenseRequest assignedLicenses(String id) {
        return new MacOsVppAppAssignedLicenseRequest(contextPath.addSegment("assignedLicenses").addKeys(new NameValue(id.toString())));
    }

}
