package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.MacOSWiredNetworkConfiguration;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class MacOSWiredNetworkConfigurationRequest extends EntityRequest<MacOSWiredNetworkConfiguration> {

    public MacOSWiredNetworkConfigurationRequest(ContextPath contextPath) {
        super(MacOSWiredNetworkConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public MacOSTrustedRootCertificateRequest rootCertificateForServerValidation() {
        return new MacOSTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"));
    }

    public MacOSCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new MacOSCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

}
