package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.MacOSScepCertificateProfile;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class MacOSScepCertificateProfileRequest extends EntityRequest<MacOSScepCertificateProfile> {

    public MacOSScepCertificateProfileRequest(ContextPath contextPath) {
        super(MacOSScepCertificateProfile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public MacOSTrustedRootCertificateRequest rootCertificate() {
        return new MacOSTrustedRootCertificateRequest(contextPath.addSegment("rootCertificate"));
    }

    public ManagedDeviceCertificateStateCollectionRequest managedDeviceCertificateStates() {
        return new ManagedDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("managedDeviceCertificateStates"));
    }

    public ManagedDeviceCertificateStateRequest managedDeviceCertificateStates(String id) {
        return new ManagedDeviceCertificateStateRequest(contextPath.addSegment("managedDeviceCertificateStates").addKeys(new NameValue(id.toString())));
    }

}
