package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.MacOSEnterpriseWiFiConfiguration;
import odata.msgraph.client.beta.entity.collection.request.MacOSTrustedRootCertificateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class MacOSEnterpriseWiFiConfigurationRequest extends EntityRequest<MacOSEnterpriseWiFiConfiguration> {

    public MacOSEnterpriseWiFiConfigurationRequest(ContextPath contextPath) {
        super(MacOSEnterpriseWiFiConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public MacOSTrustedRootCertificateRequest rootCertificateForServerValidation() {
        return new MacOSTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"));
    }

    public MacOSTrustedRootCertificateCollectionRequest rootCertificatesForServerValidation() {
        return new MacOSTrustedRootCertificateCollectionRequest(
                        contextPath.addSegment("rootCertificatesForServerValidation"));
    }

    public MacOSTrustedRootCertificateRequest rootCertificatesForServerValidation(String id) {
        return new MacOSTrustedRootCertificateRequest(contextPath.addSegment("rootCertificatesForServerValidation").addKeys(new NameValue(id.toString())));
    }

    public MacOSCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new MacOSCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

}
