package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.List;
import odata.msgraph.client.beta.entity.collection.request.ColumnDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContentTypeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityOLDCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ListItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SubscriptionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ListRequest extends EntityRequest<List> {

    public ListRequest(ContextPath contextPath) {
        super(List.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(
                        contextPath.addSegment("activities"));
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }

    public ColumnDefinitionCollectionRequest columns() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("columns"));
    }

    public ColumnDefinitionRequest columns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columns").addKeys(new NameValue(id.toString())));
    }

    public ContentTypeCollectionRequest contentTypes() {
        return new ContentTypeCollectionRequest(
                        contextPath.addSegment("contentTypes"));
    }

    public ContentTypeRequest contentTypes(String id) {
        return new ContentTypeRequest(contextPath.addSegment("contentTypes").addKeys(new NameValue(id.toString())));
    }

    public DriveRequest drive() {
        return new DriveRequest(contextPath.addSegment("drive"));
    }

    public ListItemCollectionRequest items() {
        return new ListItemCollectionRequest(
                        contextPath.addSegment("items"));
    }

    public ListItemRequest items(String id) {
        return new ListItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }

    public SubscriptionCollectionRequest subscriptions() {
        return new SubscriptionCollectionRequest(
                        contextPath.addSegment("subscriptions"));
    }

    public SubscriptionRequest subscriptions(String id) {
        return new SubscriptionRequest(contextPath.addSegment("subscriptions").addKeys(new NameValue(id.toString())));
    }

}
