package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.Journal;
import odata.msgraph.client.beta.entity.collection.request.JournalLineCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class JournalRequest extends EntityRequest<Journal> {

    public JournalRequest(ContextPath contextPath) {
        super(Journal.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccountRequest account() {
        return new AccountRequest(contextPath.addSegment("account"));
    }

    public JournalLineCollectionRequest journalLines() {
        return new JournalLineCollectionRequest(
                        contextPath.addSegment("journalLines"));
    }

    public JournalLineRequest journalLines(String id) {
        return new JournalLineRequest(contextPath.addSegment("journalLines").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "post")
    @JsonIgnore
    public ActionRequestNoReturn post() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.post"), _parameters);
    }

}
