package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Item;
import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ItemRequest extends EntityRequest<Item> {

    public ItemRequest(ContextPath contextPath) {
        super(Item.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"));
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id.toString())));
    }

    public ItemCategoryRequest itemCategory() {
        return new ItemCategoryRequest(contextPath.addSegment("itemCategory"));
    }

}
