package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ItemAnalytics;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityStatCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ItemAnalyticsRequest extends EntityRequest<ItemAnalytics> {

    public ItemAnalyticsRequest(ContextPath contextPath) {
        super(ItemAnalytics.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ItemActivityStatCollectionRequest itemActivityStats() {
        return new ItemActivityStatCollectionRequest(
                        contextPath.addSegment("itemActivityStats"));
    }

    public ItemActivityStatRequest itemActivityStats(String id) {
        return new ItemActivityStatRequest(contextPath.addSegment("itemActivityStats").addKeys(new NameValue(id.toString())));
    }

    public ItemActivityStatRequest allTime() {
        return new ItemActivityStatRequest(contextPath.addSegment("allTime"));
    }

    public ItemActivityStatRequest lastSevenDays() {
        return new ItemActivityStatRequest(contextPath.addSegment("lastSevenDays"));
    }

}
