package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ItemActivityStat;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ItemActivityStatRequest extends EntityRequest<ItemActivityStat> {

    public ItemActivityStatRequest(ContextPath contextPath) {
        super(ItemActivityStat.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ItemActivityCollectionRequest activities() {
        return new ItemActivityCollectionRequest(
                        contextPath.addSegment("activities"));
    }

    public ItemActivityRequest activities(String id) {
        return new ItemActivityRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }

}
