package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.ItemActivityOLD;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ItemActivityOLDRequest extends EntityRequest<ItemActivityOLD> {

    public ItemActivityOLDRequest(ContextPath contextPath) {
        super(ItemActivityOLD.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DriveItemRequest driveItem() {
        return new DriveItemRequest(contextPath.addSegment("driveItem"));
    }

    public ListItemRequest listItem() {
        return new ListItemRequest(contextPath.addSegment("listItem"));
    }

}
