package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.IosVppApp;
import odata.msgraph.client.beta.entity.collection.request.IosVppAppAssignedLicenseCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IosVppAppRequest extends EntityRequest<IosVppApp> {

    public IosVppAppRequest(ContextPath contextPath) {
        super(IosVppApp.class, contextPath, SchemaInfo.INSTANCE);
    }

    public IosVppAppAssignedLicenseCollectionRequest assignedLicenses() {
        return new IosVppAppAssignedLicenseCollectionRequest(
                        contextPath.addSegment("assignedLicenses"));
    }

    public IosVppAppAssignedLicenseRequest assignedLicenses(String id) {
        return new IosVppAppAssignedLicenseRequest(contextPath.addSegment("assignedLicenses").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "revokeAllLicenses")
    @JsonIgnore
    public ActionRequestNoReturn revokeAllLicenses(Boolean notifyManagedDevices) {
        Preconditions.checkNotNull(notifyManagedDevices, "notifyManagedDevices cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notifyManagedDevices", "Edm.Boolean", notifyManagedDevices)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeAllLicenses"), _parameters);
    }

    @Action(name = "revokeUserLicense")
    @JsonIgnore
    public ActionRequestNoReturn revokeUserLicense(String userId, Boolean notifyManagedDevices) {
        Preconditions.checkNotNull(notifyManagedDevices, "notifyManagedDevices cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userId", "Edm.String", Checks.checkIsAscii(userId))
            .put("notifyManagedDevices", "Edm.Boolean", notifyManagedDevices)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeUserLicense"), _parameters);
    }

    @Action(name = "revokeDeviceLicense")
    @JsonIgnore
    public ActionRequestNoReturn revokeDeviceLicense(String managedDeviceId, Boolean notifyManagedDevices) {
        Preconditions.checkNotNull(notifyManagedDevices, "notifyManagedDevices cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("managedDeviceId", "Edm.String", Checks.checkIsAscii(managedDeviceId))
            .put("notifyManagedDevices", "Edm.Boolean", notifyManagedDevices)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeDeviceLicense"), _parameters);
    }

}
