package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.IosVpnConfiguration;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IosVpnConfigurationRequest extends EntityRequest<IosVpnConfiguration> {

    public IosVpnConfigurationRequest(ContextPath contextPath) {
        super(IosVpnConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public IosCertificateProfileBaseRequest identityCertificate() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"));
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"));
    }

}
