package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.IosManagedAppProtection;
import odata.msgraph.client.beta.entity.collection.request.ManagedMobileAppCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IosManagedAppProtectionRequest extends EntityRequest<IosManagedAppProtection> {

    public IosManagedAppProtectionRequest(ContextPath contextPath) {
        super(IosManagedAppProtection.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ManagedMobileAppCollectionRequest apps() {
        return new ManagedMobileAppCollectionRequest(
                        contextPath.addSegment("apps"));
    }

    public ManagedMobileAppRequest apps(String id) {
        return new ManagedMobileAppRequest(contextPath.addSegment("apps").addKeys(new NameValue(id.toString())));
    }

    public ManagedAppPolicyDeploymentSummaryRequest deploymentSummary() {
        return new ManagedAppPolicyDeploymentSummaryRequest(contextPath.addSegment("deploymentSummary"));
    }

}
