package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.IosLobAppProvisioningConfiguration;
import odata.msgraph.client.beta.entity.IosLobAppProvisioningConfigurationAssignment;
import odata.msgraph.client.beta.entity.MobileAppProvisioningConfigGroupAssignment;
import odata.msgraph.client.beta.entity.collection.request.IosLobAppProvisioningConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppProvisioningConfigGroupAssignmentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IosLobAppProvisioningConfigurationRequest extends EntityRequest<IosLobAppProvisioningConfiguration> {

    public IosLobAppProvisioningConfigurationRequest(ContextPath contextPath) {
        super(IosLobAppProvisioningConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public MobileAppProvisioningConfigGroupAssignmentCollectionRequest groupAssignments() {
        return new MobileAppProvisioningConfigGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"));
    }

    public MobileAppProvisioningConfigGroupAssignmentRequest groupAssignments(String id) {
        return new MobileAppProvisioningConfigGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id.toString())));
    }

    public IosLobAppProvisioningConfigurationAssignmentCollectionRequest assignments() {
        return new IosLobAppProvisioningConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public IosLobAppProvisioningConfigurationAssignmentRequest assignments(String id) {
        return new IosLobAppProvisioningConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest deviceStatuses() {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"));
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusRequest deviceStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest userStatuses() {
        return new ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"));
    }

    public ManagedDeviceMobileAppConfigurationUserStatusRequest userStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<MobileAppProvisioningConfigGroupAssignment> appProvisioningConfigurationGroupAssignments, List<IosLobAppProvisioningConfigurationAssignment> iOSLobAppProvisioningConfigAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("appProvisioningConfigurationGroupAssignments", "Collection(microsoft.graph.mobileAppProvisioningConfigGroupAssignment)", appProvisioningConfigurationGroupAssignments)
            .put("iOSLobAppProvisioningConfigAssignments", "Collection(microsoft.graph.iosLobAppProvisioningConfigurationAssignment)", iOSLobAppProvisioningConfigAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
