package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.IosEnterpriseWiFiConfiguration;
import odata.msgraph.client.beta.entity.collection.request.IosTrustedRootCertificateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IosEnterpriseWiFiConfigurationRequest extends EntityRequest<IosEnterpriseWiFiConfiguration> {

    public IosEnterpriseWiFiConfigurationRequest(ContextPath contextPath) {
        super(IosEnterpriseWiFiConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public IosTrustedRootCertificateCollectionRequest rootCertificatesForServerValidation() {
        return new IosTrustedRootCertificateCollectionRequest(
                        contextPath.addSegment("rootCertificatesForServerValidation"));
    }

    public IosTrustedRootCertificateRequest rootCertificatesForServerValidation(String id) {
        return new IosTrustedRootCertificateRequest(contextPath.addSegment("rootCertificatesForServerValidation").addKeys(new NameValue(id.toString())));
    }

    public IosCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"));
    }

}
