package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.IosEasEmailProfileConfiguration;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IosEasEmailProfileConfigurationRequest extends EntityRequest<IosEasEmailProfileConfiguration> {

    public IosEasEmailProfileConfigurationRequest(ContextPath contextPath) {
        super(IosEasEmailProfileConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public IosCertificateProfileBaseRequest identityCertificate() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"));
    }

    public IosCertificateProfileRequest smimeSigningCertificate() {
        return new IosCertificateProfileRequest(contextPath.addSegment("smimeSigningCertificate"));
    }

    public IosCertificateProfileRequest smimeEncryptionCertificate() {
        return new IosCertificateProfileRequest(contextPath.addSegment("smimeEncryptionCertificate"));
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"));
    }

}
