package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.IosDeviceFeaturesConfiguration;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IosDeviceFeaturesConfigurationRequest extends EntityRequest<IosDeviceFeaturesConfiguration> {

    public IosDeviceFeaturesConfigurationRequest(ContextPath contextPath) {
        super(IosDeviceFeaturesConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public IosCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

    public IosCertificateProfileBaseRequest singleSignOnExtensionPkinitCertificate() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("singleSignOnExtensionPkinitCertificate"));
    }

}
