package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.IntuneBrandingProfile;
import odata.msgraph.client.beta.entity.IntuneBrandingProfileAssignment;
import odata.msgraph.client.beta.entity.collection.request.IntuneBrandingProfileAssignmentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IntuneBrandingProfileRequest extends EntityRequest<IntuneBrandingProfile> {

    public IntuneBrandingProfileRequest(ContextPath contextPath) {
        super(IntuneBrandingProfile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public IntuneBrandingProfileAssignmentCollectionRequest assignments() {
        return new IntuneBrandingProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public IntuneBrandingProfileAssignmentRequest assignments(String id) {
        return new IntuneBrandingProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<IntuneBrandingProfileAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.intuneBrandingProfileAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
