package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.DlpEvaluatePoliciesRequest;
import odata.msgraph.client.beta.complex.EvaluateSensitivityLabelsRequest;
import odata.msgraph.client.beta.entity.EvaluateLabelsAndPoliciesJobResponse;
import odata.msgraph.client.beta.entity.InformationProtection;
import odata.msgraph.client.beta.entity.TextClassificationRequest;
import odata.msgraph.client.beta.entity.collection.request.DataLossPreventionPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitivityLabelCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ThreatAssessmentRequestCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class InformationProtectionRequest extends EntityRequest<InformationProtection> {

    public InformationProtectionRequest(ContextPath contextPath) {
        super(InformationProtection.class, contextPath, SchemaInfo.INSTANCE);
    }

    public InformationProtectionPolicyRequest policy() {
        return new InformationProtectionPolicyRequest(contextPath.addSegment("policy"));
    }

    public SensitivityLabelCollectionRequest sensitivityLabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sensitivityLabels"));
    }

    public SensitivityLabelRequest sensitivityLabels(String id) {
        return new SensitivityLabelRequest(contextPath.addSegment("sensitivityLabels").addKeys(new NameValue(id.toString())));
    }

    public SensitivityPolicySettingsRequest sensitivityPolicySettings() {
        return new SensitivityPolicySettingsRequest(contextPath.addSegment("sensitivityPolicySettings"));
    }

    public DataLossPreventionPolicyCollectionRequest dataLossPreventionPolicies() {
        return new DataLossPreventionPolicyCollectionRequest(
                        contextPath.addSegment("dataLossPreventionPolicies"));
    }

    public DataLossPreventionPolicyRequest dataLossPreventionPolicies(String id) {
        return new DataLossPreventionPolicyRequest(contextPath.addSegment("dataLossPreventionPolicies").addKeys(new NameValue(id.toString())));
    }

    public ThreatAssessmentRequestCollectionRequest threatAssessmentRequests() {
        return new ThreatAssessmentRequestCollectionRequest(
                        contextPath.addSegment("threatAssessmentRequests"));
    }

    public ThreatAssessmentRequestRequest threatAssessmentRequests(String id) {
        return new ThreatAssessmentRequestRequest(contextPath.addSegment("threatAssessmentRequests").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "evaluateLabelsAndPolicies")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EvaluateLabelsAndPoliciesJobResponse> evaluateLabelsAndPolicies(EvaluateSensitivityLabelsRequest evaluateSensitivityLabels, DlpEvaluatePoliciesRequest evaluateDataLossPreventionPolicies, TextClassificationRequest classifyText) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("evaluateSensitivityLabels", "microsoft.graph.evaluateSensitivityLabelsRequest", evaluateSensitivityLabels)
            .put("evaluateDataLossPreventionPolicies", "microsoft.graph.dlpEvaluatePoliciesRequest", evaluateDataLossPreventionPolicies)
            .put("classifyText", "microsoft.graph.textClassificationRequest", classifyText)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<EvaluateLabelsAndPoliciesJobResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.evaluateLabelsAndPolicies"), EvaluateLabelsAndPoliciesJobResponse.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
