package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.InformationProtectionPolicy;
import odata.msgraph.client.beta.entity.collection.request.InformationProtectionLabelCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class InformationProtectionPolicyRequest extends EntityRequest<InformationProtectionPolicy> {

    public InformationProtectionPolicyRequest(ContextPath contextPath) {
        super(InformationProtectionPolicy.class, contextPath, SchemaInfo.INSTANCE);
    }

    public InformationProtectionLabelCollectionRequest labels() {
        return new InformationProtectionLabelCollectionRequest(
                        contextPath.addSegment("labels"));
    }

    public InformationProtectionLabelRequest labels(String id) {
        return new InformationProtectionLabelRequest(contextPath.addSegment("labels").addKeys(new NameValue(id.toString())));
    }

}
