package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.InferenceClassification;
import odata.msgraph.client.beta.entity.collection.request.InferenceClassificationOverrideCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class InferenceClassificationRequest extends EntityRequest<InferenceClassification> {

    public InferenceClassificationRequest(ContextPath contextPath) {
        super(InferenceClassification.class, contextPath, SchemaInfo.INSTANCE);
    }

    public InferenceClassificationOverrideCollectionRequest overrides() {
        return new InferenceClassificationOverrideCollectionRequest(
                        contextPath.addSegment("overrides"));
    }

    public InferenceClassificationOverrideRequest overrides(String id) {
        return new InferenceClassificationOverrideRequest(contextPath.addSegment("overrides").addKeys(new NameValue(id.toString())));
    }

}
